#!/bin/sh

FLAG="$HOME/.config/alinux-xfce-configured"
[ -f "$FLAG" ] && exit 0

echo "⚙️  ALinux XFCE panel configureren (first login)"

# Zorg dat xfconf draait
pgrep xfconfd >/dev/null || xfconfd &

# Reset panel
xfconf-query -c xfce4-panel -p /panels -r -R || true

# Panel basis
xfconf-query -c xfce4-panel -p /panels/panel-1/position -s "p=12;x=0;y=0"
xfconf-query -c xfce4-panel -p /panels/panel-1/size -s 40 -t int
xfconf-query -c xfce4-panel -p /panels/panel-1/length -s 100 -t int
xfconf-query -c xfce4-panel -p /panels/panel-1/length-adjust -s false -t bool

# Plugins (Windows 10 layout)
xfconf-query -c xfce4-panel -p /plugins/plugin-1 -s whiskermenu
xfconf-query -c xfce4-panel -p /plugins/plugin-2 -s pager
xfconf-query -c xfce4-panel -p /plugins/plugin-3 -s tasklist
xfconf-query -c xfce4-panel -p /plugins/plugin-4 -s separator
xfconf-query -c xfce4-panel -p /plugins/plugin-5 -s systray
xfconf-query -c xfce4-panel -p /plugins/plugin-6 -s clock
xfconf-query -c xfce4-panel -p /plugins/plugin-7 -s showdesktop

xfconf-query -c xfce4-panel -p /panels/panel-1/plugin-ids \
  -t int -s 1 -s 2 -s 3 -s 4 -s 5 -s 6 -s 7 --force-array

# Herstart panel
xfce4-panel -r

touch "$FLAG"
exit 0
