import Gtk from 'gi://Gtk?version=4.0';
import GObject from 'gi://GObject';

export const CrystalDock = GObject.registerClass({
    Signals: { 'toggle-menu': {} },
}, class CrystalDock extends Gtk.Window {
    _init(app) {
        super._init({ application: app, title: "Crystal Dock" });

        // Dock Settings
        this.set_decorated(false);
        this.set_resizable(false);
        this.add_css_class('crystal-dock-window');
        
        // Zorg dat het een dock is (Layer Shell support zou hier kunnen voor Wayland)
        // Voor X11/Mutter fallback:
        this.set_keep_above(true); 

        // Container (De zichtbare balk)
        const box = new Gtk.Box({ spacing: 10, halign: Gtk.Align.CENTER });
        box.add_css_class('crystal-dock-container');

        // 1. Start Knop
        const startBtn = new Gtk.Button({ icon_name: 'view-app-grid-symbolic' });
        startBtn.add_css_class('dock-button');
        startBtn.connect('clicked', () => this.emit('toggle-menu'));
        box.append(startBtn);

        // 2. Apps (Voorbeeld)
        const apps = ['firefox-esr', 'org.gnome.Nautilus', 'org.gnome.Terminal'];
        apps.forEach(icon => {
            const btn = new Gtk.Button({ icon_name: icon });
            btn.add_css_class('dock-button');
            box.append(btn);
        });

        this.set_child(box);
        
        // Positionering (Onderaan, gecentreerd)
        // In productie: Gebruik GdkMonitor om schermbreedte te meten
        this.set_default_size(600, 60);
        this.present();
    }
});