#!/usr/bin/gjs -m
import Gtk from 'gi://Gtk?version=4.0';
import Gdk from 'gi://Gdk';
import GLib from 'gi://GLib';
import Gio from 'gi://Gio';

// Importeer onze modules
import { CrystalDock } from './panel.js';
import { CrystalLauncher } from './launcher.js';

const APP_ID = 'org.alinux.crystal.shell';

const CrystalShell = GObject.registerClass(
    class CrystalShell extends Gtk.Application {
        _init() {
            super._init({ application_id: APP_ID });
        }

        vfunc_activate() {
            // Laad CSS
            const provider = new Gtk.CssProvider();
            provider.load_from_path('/usr/share/crystal-de/artwork/shell.css');
            Gtk.StyleContext.add_provider_for_display(
                Gdk.Display.get_default(),
                provider,
                Gtk.STYLE_PROVIDER_PRIORITY_APPLICATION
            );

            // Start de Dock
            this.dock = new CrystalDock(this);
            
            // Start de Launcher (standaard verborgen)
            this.launcher = new CrystalLauncher(this);
            
            // Koppel signaal: Als op startknop gedrukt wordt in dock -> toggle launcher
            this.dock.connect('toggle-menu', () => this.launcher.toggle());
        }
    }
);

const app = new CrystalShell();
app.run([]);