#!/usr/bin/gjs -m
import Gtk from 'gi://Gtk?version=4.0';
import Adw from 'gi://Adw?version=1';
import Vte from 'gi://Vte?version=2.91'; // Let op versie
import GLib from 'gi://GLib';
import Gdk from 'gi://Gdk';

Gtk.init();
Adw.init();

const app = new Adw.Application({ application_id: 'org.alinux.crystal.terminal' });

app.connect('activate', () => {
    const win = new Adw.Window({ title: "Terminal", default_width: 900, default_height: 600 });
    
    // Zwarte achtergrond/transparantie
    const css = new Gtk.CssProvider();
    css.load_from_data(`.terminal-window { background-color: rgba(0,0,0,0.85); }`);
    win.add_css_class('terminal-window');

    const header = new Adw.HeaderBar();
    win.set_titlebar(header);

    const terminal = new Vte.Terminal();
    
    // Spawn shell
    terminal.spawn_async(
        Vte.PtyFlags.DEFAULT,
        GLib.get_home_dir(),
        [GLib.getenv("SHELL") || "/bin/bash"],
        [],
        GLib.SpawnFlags.DO_NOT_REAP_CHILD,
        null, null, null
    );

    win.set_content(terminal);
    win.present();
});

app.run([]);