#!/usr/bin/gjs -m
import Gtk from 'gi://Gtk?version=4.0';
import Adw from 'gi://Adw?version=1';
import GLib from 'gi://GLib';

// Initialiseer
Gtk.init();
Adw.init();

const app = new Adw.Application({ application_id: 'org.alinux.crystal.settings' });

app.connect('activate', () => {
    const win = new Adw.PreferencesWindow({
        title: "Instellingen",
        default_width: 900,
        default_height: 600
    });

    // --- PAGINA 1: PERSONALISATIE ---
    const pagePersonal = new Adw.PreferencesPage({
        title: "Personalisatie",
        icon_name: "preferences-desktop-wallpaper"
    });

    const groupTheme = new Adw.PreferencesGroup({ title: "Thema & Uiterlijk" });
    
    // Thema kiezer (Light/Dark/Auto)
    const rowTheme = new Adw.ActionRow({ title: "Applicatie Thema" });
    const switchTheme = new Gtk.Switch({ active: true }); // Simpele toggle voor nu
    rowTheme.add_suffix(switchTheme);
    
    // Accent Kleur (Deepin stijl)
    const rowColor = new Adw.ActionRow({ title: "Accent Kleur" });
    // Hier zou je custom kleur-rondjes toevoegen
    
    groupTheme.add(rowTheme);
    groupTheme.add(rowColor);
    pagePersonal.add(groupTheme);

    // --- PAGINA 2: SYSTEEM ---
    const pageSystem = new Adw.PreferencesPage({
        title: "Systeem",
        icon_name: "emblem-system"
    });
    
    const groupInfo = new Adw.PreferencesGroup();
    const rowOs = new Adw.ActionRow({ title: "OS Versie", subtitle: "ALinux Voltron 15.0" });
    groupInfo.add(rowOs);
    pageSystem.add(groupInfo);

    // Opbouwen
    win.add(pagePersonal);
    win.add(pageSystem);
    
    win.present();
});

app.run([]);