#!/usr/bin/gjs -m
import Gtk from 'gi://Gtk?version=4.0';
import Adw from 'gi://Adw?version=1';
import Gdk from 'gi://Gdk';

Gtk.init();
Adw.init();

const app = new Adw.Application({ application_id: 'org.alinux.crystal.calculator' });

app.connect('activate', () => {
    const win = new Adw.Window({ title: "Calculator", default_width: 300, default_height: 450 });
    
    // CSS laden voor specifieke calculator styling
    const provider = new Gtk.CssProvider();
    provider.load_from_data(`
        .calc-btn { font-size: 18px; font-weight: bold; margin: 4px; border-radius: 50%; }
        .calc-display { font-size: 32px; padding: 20px; background: transparent; }
        .calc-accent { background-color: #2ca7f8; color: white; }
    `);
    Gtk.StyleContext.add_provider_for_display(Gdk.Display.get_default(), provider, Gtk.STYLE_PROVIDER_PRIORITY_APPLICATION);

    const mainBox = new Gtk.Box({ orientation: Gtk.Orientation.VERTICAL });
    
    // Header
    const header = new Adw.HeaderBar({ show_end_title_buttons: true });
    win.set_titlebar(header);

    // Display
    const display = new Gtk.Label({ label: "0", xalign: 1 });
    display.add_css_class('calc-display');
    mainBox.append(display);

    // Buttons Grid
    const grid = new Gtk.Grid({ column_homogeneous: true, row_homogeneous: true, hexpand: true, vexpand: true });
    
    const buttons = [
        ['C', '(', ')', '/'],
        ['7', '8', '9', '*'],
        ['4', '5', '6', '-'],
        ['1', '2', '3', '+'],
        ['0', '.', '=', '']
    ];

    let currentInput = "";

    buttons.forEach((row, rowIndex) => {
        row.forEach((label, colIndex) => {
            if (!label) return;
            const btn = new Gtk.Button({ label: label });
            btn.add_css_class('calc-btn');
            if (['/', '*', '-', '+', '='].includes(label)) btn.add_css_class('calc-accent');

            btn.connect('clicked', () => {
                if (label === 'C') {
                    currentInput = "";
                    display.set_label("0");
                } else if (label === '=') {
                    try {
                        // Veiligere eval alternatief of simpele eval voor demo
                        display.set_label(String(eval(currentInput))); 
                        currentInput = display.get_label();
                    } catch {
                        display.set_label("Error");
                        currentInput = "";
                    }
                } else {
                    currentInput += label;
                    display.set_label(currentInput);
                }
            });
            grid.attach(btn, colIndex, rowIndex, 1, 1);
        });
    });

    mainBox.append(grid);
    win.set_content(mainBox);
    win.present();
});

app.run([]);